implementation module processstack


//	Clean Object I/O library, version 1.1


from	StdOverloaded	import ==
from	StdString	import	String
from	commondef	import	Error
from	systemid	import	SystemId, NullSystemId


::	ProcessShowState
	=	{	psId	:: !SystemId		// the id of the process
		,	psShow	:: !ShowFlag		// flag: True iff the process is visible
		,	psKind	:: !ProcessKind		// the kind of the process
		}
::	ProcessKind		=	InteractiveProcess | VirtualProcess
::	ShowFlag		:==	Bool
::	ProcessStack	:==	[ProcessShowState]


processStackError :: String String -> .x
processStackError rule error = Error rule "processstack" error


instance == ProcessKind
where
	(==) :: !ProcessKind !ProcessKind -> Bool
	(==) InteractiveProcess kind	= case kind of
										InteractiveProcess	-> True
										_					-> False
	(==) VirtualProcess		kind	= case kind of
										VirtualProcess		-> True
										_					-> False
	
emptyProcessStack :: ProcessStack
emptyProcessStack = []

pushProcessShowState :: !ProcessShowState !ProcessStack -> ProcessStack
pushProcessShowState idVisible psStack = [idVisible:psStack]

selectProcessShowState :: !SystemId !ProcessStack -> ProcessStack
selectProcessShowState id psStack
	= [idVisible:psStack`]
where
	(idVisible,psStack`) = removeProcessShowState id psStack

removeProcessShowState :: !SystemId !ProcessStack -> (!ProcessShowState, !ProcessStack)
removeProcessShowState id [idVisible=:{psId}:psStack]
	| id==psId
	= (idVisible, psStack)
	= (idVisible`,[idVisible:psStack`])
	with
		(idVisible`,psStack`)	= removeProcessShowState id psStack
removeProcessShowState _ _
	= processStackError "removeProcessShowState" "Unknown SystemId"

setProcessShowState :: !SystemId !Bool !ProcessStack -> ProcessStack
setProcessShowState id show [idVisible=:{psId}:psStack]
	| id==psId
	= [{idVisible & psShow=show}:psStack]
	= [idVisible:setProcessShowState id show psStack]
setProcessShowState _ _ _
	= processStackError "setProcessShowState" "Unknown SystemId"

topShowProcessShowState :: !ProcessStack -> (!Bool,!SystemId)
topShowProcessShowState [{psId,psShow}:psStack]
	| psShow
	= (psShow,psId)
	= topShowProcessShowState psStack
topShowProcessShowState _
	= (False,NullSystemId)
